/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.apps.designer;

import filenet.sim.apps.designer.resources.VWSIMResource;
import filenet.sim.toolkit.utils.VWSIMHelp;
import filenet.vw.api.VWException;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.IVWMouseActionListener;
import filenet.vw.toolkit.utils.VWMouseAdapter;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWDialogButtons;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.event.IVWDialogButtonsActionListener;
import filenet.vw.toolkit.utils.event.VWDialogButtonsActionEvent;
import filenet.vw.toolkit.utils.table.VWSortedListModel;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.MouseEvent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

class VWSIMWorkflowDialog
extends VWModalDialog
implements IVWDialogButtonsActionListener,
IVWMouseActionListener {
    private VWToolbarBorder m_workflowBorder = null;
    private JList m_workflowList = null;
    private VWSortedListModel m_workflowListModel = null;
    private VWDialogButtons m_buttons = null;
    private Frame m_parentFrame = null;
    private VWSession m_session = null;

    public VWSIMWorkflowDialog(Frame parentFrame, VWSession session) {
        super(parentFrame);
        try {
            this.m_parentFrame = parentFrame;
            this.m_session = session;
            this.setTitle(VWSIMResource.s_importWorkflowFromWorkflowServer);
            Dimension dim = VWStringUtils.stringToDimension("505,335");
            if (dim != null) {
                this.setSize(dim);
            }
            this.getContentPane().setLayout(new BorderLayout());
            this.m_workflowBorder = new VWToolbarBorder(VWSIMResource.s_workflowNames);
            this.getContentPane().add((Component)this.m_workflowBorder, "Center");
            JPanel workflowPanel = this.m_workflowBorder.getClientPanel();
            workflowPanel.setLayout(new BorderLayout());
            this.m_workflowListModel = new VWSortedListModel();
            this.m_workflowList = new JList(this.m_workflowListModel);
            this.m_workflowList.getSelectionModel().setSelectionMode(0);
            workflowPanel.add(new JScrollPane(this.m_workflowList));
            this.m_buttons = new VWDialogButtons(35);
            this.m_buttons.addDialogButtonsActionListener(this);
            this.getContentPane().add((Component)this.m_buttons, "Last");
            this.initWorkflowNamesList();
            this.m_workflowList.addMouseListener(new VWMouseAdapter(this));
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public VWWorkflowDefinition[] getWorkflowDefinitions() {
        VWWorkflowDefinition[] wflDefs = null;
        try {
            Object[] wflNames = this.m_workflowList.getSelectedValues();
            if (wflNames != null && wflNames.length > 0) {
                wflDefs = new VWWorkflowDefinition[wflNames.length];
                for (int i = 0; i < wflNames.length; ++i) {
                    wflDefs[i] = this.m_session.fetchWorkflowDefinition(-1, (String)wflNames[i], true);
                }
            }
        }
        catch (VWException ex) {
            VWMessageDialog.showOptionDialog(this.m_parentFrame, ex.getLocalizedMessage(), 1);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return wflDefs;
    }

    public void dialogButtonsActionPerformed(VWDialogButtonsActionEvent event) {
        switch (event.getID()) {
            case 1: {
                this.m_nExitStatus = 0;
                this.setVisible(false);
                break;
            }
            case 2: {
                this.m_nExitStatus = 1;
                this.setVisible(false);
                break;
            }
            case 32: {
                VWSIMHelp.displayPage(VWSIMHelp.Help_Simulation_Designer + "vwsimworkflowdialog.htm");
            }
        }
    }

    public void doubleClickedItem(MouseEvent event) {
        this.dialogButtonsActionPerformed(new VWDialogButtonsActionEvent(this, 1));
    }

    public void createPopup(MouseEvent event) {
    }

    private void initWorkflowNamesList() {
        try {
            int count;
            this.m_workflowListModel.removeAllElements();
            String[] workflowNames = this.m_session.fetchWorkClassNames(false);
            if (workflowNames != null && (count = workflowNames.length) > 0) {
                for (int i = 0; i < count; ++i) {
                    this.m_workflowListModel.addElement(workflowNames[i]);
                }
                this.m_workflowListModel.sort();
            }
        }
        catch (VWException ex) {
            VWMessageDialog.showOptionDialog(this.m_parentFrame, ex.getLocalizedMessage(), 1);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

